<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Transaction extends Model 
{

    protected $table = 'transactions';
    public $timestamps = true;
    protected $fillable = array('user_id', 'pocket_id', 'currency', 'value', 'isExpense', 'date', 'description');

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }

    public function pockets()
    {
        return $this->belongsTo('App\Models\Pocket', 'pockets_id');
    }

    public function uploads()
    {
        return $this->hasMany('App\Models\PocketUpload', 'transaction_id');
    }

    public function subtransactions()
    {
        return $this->hasMany('App\Models\Subtransaction', 'transaction_id');
    }

}